 <!-- Datatable style -->
 <link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap4.css">

 <div class="content-wrapper">
     <section class="content">
         <!-- For Messages -->
         <?php $this->load->view('admin/includes/_messages.php') ?>
         <div class="card">
             <div class="card-header">
                 <div class="d-inline-block">
                     <h3 class="card-title"><i class="fa fa-list"></i>&nbsp; Buyer List</h3>
                 </div>
                 <div class="d-inline-block float-right">
                     <?php if($this->rbac->check_operation_permission('add')): ?>
                     <a href="<?= base_url('admin/buyer_manager/add'); ?>" class="btn btn-success"><i
                             class="fa fa-plus"></i> Add New Buyer</a>
                     <?php endif; ?>
                 </div>
             </div>
             <div class="card-body">
                 <div class="card card-default">
                     <?php echo form_open(base_url('admin/buyer_manager/list'), '');  ?>
                     <div class="card-header">
                         <h3 class="card-title">Search</h3>

                         <div class="card-tools">
                             <button type="button" class="btn btn-tool" data-widget="collapse" fdprocessedid="pu54bt"><i
                                     class="fa fa-minus"></i></button>
                             <button type="button" class="btn btn-tool" data-widget="remove" fdprocessedid="dtn5d"><i
                                     class="fa fa-remove"></i></button>
                         </div>
                     </div>
                     <div class="card-body" style="display: block;">
                         <div class="row">
                             <div class="col-md-6">
                                 <div class="form-group">
                                     <label>Name</label>
                                     <input type="text" value="<?=$search['name'];?>" name="name" class="form-control">
                                  </div>
                             </div>
                             <div class="col-md-6">
                         </div>
                     </div>
                     <div class="card-footer" style="display: block;">
                         <button type="submit" class="btn btn-info float-right" fdprocessedid="t8ct0o"> Search </button>
                     </div>
                     <?php echo form_close( ); ?>
                 </div>
                 <table id="na_datatable" class="table table-bordered table-striped ">
                     <thead>
                         <tr>
                             <th>Name</th>
                             <th>Email</th>
                             <th style="width: 150px;" class="text-right">Action</th>
                         </tr>
                         <?php foreach ($buyer_list as $buyer): ?>
                         <tr>
                             <td><?= $buyer->buyerName ?></td>
                             <td><?= $buyer->buyerEmail ?></td>
                               <td class="text-right">
                                 <a title="Edit" class="update btn btn-sm btn-warning"
                                     href="<?=base_url('admin/buyer_manager/edit/'.$buyer->buyer_id)?>"> <i
                                         class="fa fa-pencil-square-o"></i></a>

                             </td>
                         </tr>
                         <?php endforeach; ?>
                     </thead>
                 </table>

             </div>
             <div class="card-footer clearfix">
                 <?php echo $links; ?>
             </div>
         </div>
     </section>
 </div>

