<?php
	class Cron_model extends CI_Model{

		public function add_report($data){
			$this->db->insert('ci_report', $data);
			return $this->db->insert_id();
		}

		public function buyer_email($data){
			$buyerDetails = $this->db->get_where('ci_buyer', array('buyerID' => $data['buyerID']))->row();
			if (!$buyerDetails) {
				$this->db->insert('ci_buyer', $data);
			
				return 'adops@callsbybrand.com';
			} else {
				return $buyerDetails->buyerEmail;
			}
		}

		public function get_email_template(){			
			$query = $this->db->get_where('ci_email_templates', array('id' => 1));
			return $result = $query->row_array();
		}
		
		public function get_email_template_for_notListedBuyer(){			
			$query = $this->db->get_where('ci_email_templates', array('id' => 2));
			return $result = $query->row_array();
		}

		public function get_email_variables(){			
			$this->db->from('ci_email_template_variables');
			$this->db->where('template_id',1);
			$query=$this->db->get();
			return $query->result_array();
		}

		public function update_lead($data,$id){
			$this->db->where('admin_id', $id);
			$this->db->update('ci_admin', $data);
			return true;
		}

		function get_all_report($buyer_id)
		{
		    if(date("d")==1){
                $thisMonth = date("m", strtotime("-1 month")); // Get the current month (in MM format)
		    }else{
		        $thisMonth = date("m");
		    }
            $thisYear = date('Y'); // Get the current year
			$this->db->from('ci_report');
			$this->db->where('buyerID',$buyer_id);
            $this->db->where('MONTH(addDate)', $thisMonth);
            $this->db->where('YEAR(addDate)', $thisYear);
			$this->db->order_by('contractID','desc');
			$query = $this->db->get();
			return $query->result_array();
		}
		
		function get_rest_buyer($todaysBuyer)
		{
		    $this->db->from('ci_buyer');
			$this->db->where_not_in('buyerID',$todaysBuyer);
			$query = $this->db->get();
			return $query->result_array();
		}
		
		
		/// Deleted part
		
		function get_all_report_monthly($buyer_id)
		{
            $thisMonth = date("m", strtotime("-1 month")); // Get the previous month (in MM format)
            $thisYear = date('Y'); // Get the current year
			$this->db->from('ci_report');
			$this->db->where('buyerID',$buyer_id);
            $this->db->where('MONTH(addDate)', $thisMonth);
            $this->db->where('YEAR(addDate)', $thisYear);
			$this->db->order_by('contractID','desc');
			$query = $this->db->get();
			return $query->result_array();
		}
		
		public function buyer_details(){
			$this->db->from('ci_buyer');
			$query = $this->db->get();
			return $query->result_array();
		}
	}

?>