<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Cms_manager extends MY_Controller
{
	function __construct()
	{
		parent ::__construct();
		auth_check(); // check login auth
        $this->rbac->check_module_access();

		$this->load->library('datatable'); 
		$this->load->model('admin/cms_manager_model', 'cms_manager_model');
	}

	public function index()
	{
		$data['title'] = 'CMS Manager';		
		$data['search']['name'] 			= ($this->input->post('name'))?$this->input->post('name'):'';


		$pagination["base_url"] = base_url() . "admin/cms_manager/list";
		$pagination["total_rows"] = $this->cms_manager_model->get_count($data['search']);
		$pagination["uri_segment"] = 4;
		$pagination["per_page"] = 100;
		$pagination["current_page"] = ($this->uri->segment($pagination["uri_segment"])) ? $this->uri->segment($pagination["uri_segment"]) : 0;

        $data["links"] = pagination_generation($pagination);

        $data['cms_list'] = $this->cms_manager_model->get_all_cms($data['search'],$pagination);

		$this->load->view('admin/includes/_header', $data);
		$this->load->view('admin/cms_manager/list', $data);
		$this->load->view('admin/includes/_footer', $data);
	}
	
		public function list()
	{
		$data['title'] = 'CMS Manager';		
		$data['search']['name'] 			= ($this->input->post('name'))?$this->input->post('name'):'';


		$pagination["base_url"] = base_url() . "admin/cms_manager/list";
		$pagination["total_rows"] = $this->cms_manager_model->get_count($data['search']);
		$pagination["uri_segment"] = 4;
		$pagination["per_page"] = 10;
		$pagination["current_page"] = ($this->uri->segment($pagination["uri_segment"])) ? $this->uri->segment($pagination["uri_segment"]) : 0;

        $data["links"] = pagination_generation($pagination);

        $data['cms_list'] = $this->cms_manager_model->get_all_cms($data['search'],$pagination);

		$this->load->view('admin/includes/_header', $data);
		$this->load->view('admin/cms_manager/list', $data);
		$this->load->view('admin/includes/_footer', $data);
	}

	//-----------------------------------------------------
	public function add()
	{
		
		$data['title'] 					= 'Add CMS';

		$data['insert']['name'] 				= ($this->input->post('name'))?$this->input->post('name'):'';
		$data['insert']['content']				= ($this->input->post('content'))?$this->input->post('content'):'';


		if($this->input->post()){
			$this->form_validation->set_rules('name', 'CMS Name', 'trim|required');
			$this->form_validation->set_rules('content', 'Content', 'trim|required');

			$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
			if ($this->form_validation->run() === FALSE) {
				$this->load->view('admin/includes/_header', $data);
				$this->load->view('admin/cms_manager/add', $data);
				$this->load->view('admin/includes/_footer', $data);
				return;
			}
			
			$insert_data = $this->security->xss_clean($data['insert']);
			$result = $this->cms_manager_model->add_cms($insert_data);
			$this->session->set_flashdata('success','CMS content has been added successfully');
			redirect(base_url('admin/cms_manager/list'));
		}
		else{

			$this->load->view('admin/includes/_header', $data);
			$this->load->view('admin/cms_manager/add', $data);
			$this->load->view('admin/includes/_footer', $data);
		}
	}

	//-----------------------------------------------------
	public function edit($id=0)
	{

		$data['title'] 					= 'Edit CMS';
		$Update							= $this->cms_manager_model->get_cms_by_id($id);

		$data['insert']['name'] 				= ($this->input->post('name'))?$this->input->post('name'):$Update['name'];
		$data['insert']['content']				= ($this->input->post('content'))?$this->input->post('content'):$Update['content'];
		$data['insert']['status'] 				= ($this->input->post('status')!='')?$this->input->post('status'):$Update['status'];
		$data['insert']['id'] 						= ($this->input->post('id'))?$this->input->post('id'):$Update['id'];
		
		if($this->input->post()){
			$this->form_validation->set_rules('name', 'CMS Name', 'trim|required');
			$this->form_validation->set_rules('content', 'Content', 'trim|required');

			$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
			if ($this->form_validation->run() === FALSE) {
				$this->load->view('admin/includes/_header', $data);
				$this->load->view('admin/cms_manager/edit', $data);
				$this->load->view('admin/includes/_footer', $data);
				return;
			}
			
			$insert_data = $this->security->xss_clean($data['insert']);
			$result = $this->cms_manager_model->edit_cms($insert_data,$id);
			$this->session->set_flashdata('success','CMS Content has been Updated successfully');
			redirect(base_url('admin/cms_manager/list'));
		}
		else{

			$this->load->view('admin/includes/_header', $data);
			$this->load->view('admin/cms_manager/edit', $data);
			$this->load->view('admin/includes/_footer', $data);
		}
	}

	//-----------------------------------------------------
	public function price_del($id)
	{
		// $this->db->delete('price_section', array('id' => $id));
		// $this->session->set_flashdata('success', 'Lead Price has been Deleted Successfully!');
		// redirect(base_url('admin/cms_manager/list'));
	}


}

?>