<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Buyer_manager extends MY_Controller
{
	function __construct()
	{
		parent ::__construct();
		auth_check(); // check login auth
        $this->rbac->check_module_access();

		$this->load->library('datatable'); 
		$this->load->model('admin/buyer_manager_model', 'buyer_manager_model');
	}

	public function index()
	{
		$data['title'] = 'Buyer Manager';		
		$data['search']['name'] 			= ($this->input->post('name'))?$this->input->post('name'):'';


		$pagination["base_url"] = base_url() . "admin/buyer_manager/list";
		$pagination["total_rows"] = $this->buyer_manager_model->get_count($data['search']);
		$pagination["uri_segment"] = 4;
		$pagination["per_page"] = 10;
		$pagination["current_page"] = ($this->uri->segment($pagination["uri_segment"])) ? $this->uri->segment($pagination["uri_segment"]) : 0;

        $data["links"] = pagination_generation($pagination);

        $data['buyer_list'] = $this->buyer_manager_model->get_all_buyer($data['search'],$pagination);

		$this->load->view('admin/includes/_header', $data);
		$this->load->view('admin/buyer_manager/list', $data);
		$this->load->view('admin/includes/_footer', $data);
	}
	public function list()
	{
		$data['title'] = 'Buyer Manager';		
		$data['search']['name'] 			= ($this->input->post('name'))?$this->input->post('name'):'';


		$pagination["base_url"] = base_url() . "admin/buyer_manager/list";
		$pagination["total_rows"] = $this->buyer_manager_model->get_count($data['search']);
		$pagination["uri_segment"] = 4;
		$pagination["per_page"] = 10;
		$pagination["current_page"] = ($this->uri->segment($pagination["uri_segment"])) ? $this->uri->segment($pagination["uri_segment"]) : 0;

        $data["links"] = pagination_generation($pagination);

        $data['buyer_list'] = $this->buyer_manager_model->get_all_buyer($data['search'],$pagination);

		$this->load->view('admin/includes/_header', $data);
		$this->load->view('admin/buyer_manager/list', $data);
		$this->load->view('admin/includes/_footer', $data);
	}
	//-----------------------------------------------------
	public function add()
	{
		
		$data['title'] 					= 'Add Buyer';

		$data['insert']['name'] 				= ($this->input->post('name'))?$this->input->post('name'):'';
		$data['insert']['content']				= ($this->input->post('content'))?$this->input->post('content'):'';


		if($this->input->post()){
			$this->form_validation->set_rules('name', 'CMS Name', 'trim|required');
			$this->form_validation->set_rules('content', 'Content', 'trim|required');

			$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
			if ($this->form_validation->run() === FALSE) {
				$this->load->view('admin/includes/_header', $data);
				$this->load->view('admin/buyer_manager/add', $data);
				$this->load->view('admin/includes/_footer', $data);
				return;
			}
			
			$insert_data = $this->security->xss_clean($data['insert']);
			$result = $this->buyer_manager_model->add_buyer($insert_data);
			$this->session->set_flashdata('success','Buyer content has been added successfully');
			redirect(base_url('admin/buyer_manager/list'));
		}
		else{

			$this->load->view('admin/includes/_header', $data);
			$this->load->view('admin/buyer_manager/add', $data);
			$this->load->view('admin/includes/_footer', $data);
		}
	}

	//-----------------------------------------------------
	public function edit($buyer_id=0)
	{

		$data['title'] 					= 'Edit Buyer';
		$Update							= $this->buyer_manager_model->get_buyer_by_id($buyer_id);

		$data['insert']['buyerName'] 			= ($this->input->post('buyerName'))?$this->input->post('buyerName'):$Update['buyerName'];
		$data['insert']['buyerEmail']			= ($this->input->post('buyerEmail'))?$this->input->post('buyerEmail'):$Update['buyerEmail'];
		$data['insert']['buyer_id'] 			= ($this->input->post('buyer_id'))?$this->input->post('buyer_id'):$Update['buyer_id'];
		
		if($this->input->post()){
			$this->form_validation->set_rules('buyerName', 'Buyer Name', 'trim|required');
		//	$this->form_validation->set_rules('buyerEmail', 'Email', 'trim|required|valid_email');

			$this->form_validation->set_error_delimiters('<div class="alert alert-danger">', '</div>');
			if ($this->form_validation->run() === FALSE) {
				$this->load->view('admin/includes/_header', $data);
				$this->load->view('admin/buyer_manager/edit', $data);
				$this->load->view('admin/includes/_footer', $data);
				return;
			}
			
			$insert_data = $this->security->xss_clean($data['insert']);
			$result = $this->buyer_manager_model->edit_buyer($insert_data,$buyer_id);
			$this->session->set_flashdata('success','Buyer Content has been Updated successfully');
			redirect(base_url('admin/buyer_manager/list'));
		}
		else{

			$this->load->view('admin/includes/_header', $data);
			$this->load->view('admin/buyer_manager/edit', $data);
			$this->load->view('admin/includes/_footer', $data);
		}
	}


}

?>