<?php defined('BASEPATH') or exit('No direct script access allowed');

class Cronmonthly extends MY_Controller
{
    public function __construct()
    {

        parent::__construct();
        $this->load->model('Cron_model', 'cron_model');
    }


	function index()
	{
	    $buyerdetails = $this->cron_model->buyer_details();
	    /*
	    echo '<pre>';
	    print_r($buyerdetails);
	    echo '</pre>';
	    exit;
	    */
		if(count($buyerdetails)>0)
		{
			$emailTemp = $this->cron_model->get_email_template();
			//$variables= $this->cron_model->get_email_variables();
			$email_subject = str_replace("{{DATE}}", date("Y-m-d", strtotime("-1 day")), $emailTemp['subject']);
			$html_email_template = '<!DOCTYPE html>
									<html lang="en">
									<head>
									<meta charset="UTF-8">
									<title>Email Template with Table</title>
									<style>
										/* Define styles for your table */
										table {
										border-collapse: collapse;
										width: 100%;
										}
										th, td {
										border: 1px solid #dddddd;
										text-align: left;
										padding: 8px;
										}
										th {
										background-color: #f2f2f2;
										}
									</style>
									</head>
									<body>';
			$html_email_template .= $emailTemp['body'];
			$html_email_template .= '</body></html>';
			
			foreach ($buyerdetails as $buyerArr) 
			{

				    $config = array(
                        'protocol' => 'smtp', // 'mail', 'sendmail', or 'smtp'
                        'smtp_host' => 'smtp.gmail.com',
                        'smtp_port' => 587,
                        'smtp_user' => 'developer.pappu@gmail.com',
                        'smtp_pass' => 'letp ozuq mpwn cgkq',
                        'smtp_crypto' => 'security', //can be 'ssl' or 'tls' for example
                        'mailtype' => 'html', //plaintext 'text' mails or 'html'
                        'smtp_timeout' => '4', //in seconds
                        'charset' => 'utf-8',
                        'wordwrap' => TRUE
                    );
                    

                    $from = 'reports@callsbybrand.com';
                    //$to= $buyerArr['buyerEmail'];
                    $to= 'palash@colbygroup.net,rkakkar@colbygroup.net';
                    $subject = 'CBB Monthly Call Logs of - '.date("F", strtotime("-1 day"));

					$table_html = 'This is monthly report';


					$placeholders = array('{{BUYERNAME}}', '{{TABLE}}','{{DATE}}');
					$actual_values = array($buyerArr['buyerName'], $table_html, date("Y-m-d", strtotime("-1 day")));

					$final_email_content = str_replace($placeholders, $actual_values, $html_email_template);

					//echo $final_email_content;

					$file_path = './csv/'.$buyerArr['buyerID'].'-'.date("M", strtotime("-1 month")).'.xlsx';
					$this->generate_excel($buyerArr['buyerID'],$file_path);

                    $this->email->clear(TRUE);
                    $this->load->library('email',$config); 
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->set_crlf("\r\n");

                    $this->email->from( $from, 'Callsbybrand');
                    $this->email->to($to);
                    $this->email->bcc('reports@callsbybrand.com');
                    $this->email->subject($subject);
                    $this->email->message($final_email_content);
				    $this->email->attach($file_path); 
  
					if ($this->email->send()) {
						echo 'Email sent successfully!';
					} else {
						echo 'Email sending failed.';
						echo $this->email->print_debugger(); // Print email debug information if needed
					}
			}
		}
	}

	function generate_excel($buyer_id,$file_path)
	{
		$this->load->library('SimpleXLSXGen');

		$returnData = $this->cron_model->get_all_report_monthly($buyer_id);

		$xlsx = new SimpleXLSXGen();

		$csv_header = ['contractID','callFrom','transferDuration','revenue','createdOn','country','region','city','verticalName','contractName','buyerID','buyerName','date'];
		$count=0;
		$contractchecking =0;
		$appendCounter=	1;
		$duration = 0;
		$revenue = 0;
		$csvData = array();
		$nameArray = array_column($returnData, 'contractID');
		$distinctLengths = array_unique(array_map('strlen', $nameArray));
		foreach ($returnData as $data) 
		{
			if($count === 0){
				array_push($csvData,$csv_header);
				array_push($csvData,$data);

			}elseif($contractchecking === $data['contractID']){
				array_push($csvData,$data);
				$appendCounter++;
			}elseif($contractchecking != $data['contractID']){
				$appendCounter = 0;
			}
			$count++;
			if(count($distinctLengths) ===1 && count($returnData) === $count)
			{
				$appendCounter = 0;
			}

			if($appendCounter===0){
				$row_count = count($csvData)-1;
				$xlsx->addSheet($csvData,$csvData[1]['contractID'].' ('.$row_count.')');
				$duration = 0;
				$revenue = 0;
				$csvData = array();
				array_push($csvData,$csv_header);
				array_push($csvData,$data);
			}
			$contractchecking = $data['contractID'];
		}
		$xlsx->saveAs($file_path);
	}
}
