<?php defined('BASEPATH') or exit('No direct script access allowed');

class Cron extends MY_Controller
{
    public function __construct()
    {

        parent::__construct();
        $this->load->model('Cron_model', 'cron_model');
    }

    //-----------------------------------------------------
    public function index()
    {
		$returnData = array();
		$curl = curl_init();
		
		curl_setopt_array($curl, [
            // CURLOPT_URL => $this->config->item('leadspedia_post_url').'?fromDate=2024-02-05&toDate=2024-02-05&limit=1000',
            CURLOPT_URL => $this->config->item('leadspedia_post_url').'?fromDate='.date("Y-m-d", strtotime("-1 day")).'&toDate='.date("Y-m-d", strtotime("-1 day")).'&limit=1000',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
            "Authorization: Basic ".$this->config->item('leadspedia_auth_token')
            ],
		]);
		
		$response = curl_exec($curl);
		curl_close($curl);
		$returnArr = json_decode($response);

		// echo '<pre>';
		// print_r($returnArr->response->data);
		// echo '</pre>';

        if ($returnArr->success === true) {
			$dataArr = $returnArr->response->data;
            if (count($dataArr) > 0) 
			{
				$buyerID = array();
                foreach ($dataArr as $returnVal) {
					if($returnVal->revenue >0 && $returnVal->isTest==="No")
					{
						$findingVal = $returnVal->buyerID;
						$findingVal2 = $returnVal->contractID;

						if (in_array($findingVal, $buyerID))
						{
							array_push($buyerID[$findingVal],$findingVal2);
						}else{
							array_push($buyerID,$findingVal);
							$buyerID[$findingVal] = array();
						}

						$key =  array_search($findingVal, $buyerID);
						$key2 = count($buyerID[$findingVal]);
						$returnData[$key][$key2]['contractID']		= $returnVal->contractID;
						$returnData[$key][$key2]['callFrom']		= $returnVal->callFrom;
						$returnData[$key][$key2]['transferDuration']= $returnVal->transferDuration;
						$returnData[$key][$key2]['revenue']			= $returnVal->revenue;
						$returnData[$key][$key2]['createdOn']		= $returnVal->createdOn;
						$returnData[$key][$key2]['country']			= $returnVal->country;
						$returnData[$key][$key2]['region']			= $returnVal->region;
						$returnData[$key][$key2]['city']			= $returnVal->city;
						$returnData[$key][$key2]['verticalName']	= $returnVal->verticalName;
						$returnData[$key][$key2]['contractName']	= $returnVal->contractName;
						$returnData[$key][$key2]['buyerID']			= $returnVal->buyerID;
						$returnData[$key][$key2]['buyerName']		= $returnVal->buyerName;

						$insert['contractID']		= $returnVal->contractID;
						$insert['callFrom']			= $returnVal->callFrom;
						$insert['transferDuration']	= $returnVal->transferDuration;
						$insert['revenue']			= $returnVal->revenue;
						$insert['createdOn']		= $returnVal->createdOn;
						$insert['country']			= $returnVal->country;
						$insert['region']			= $returnVal->region;
						$insert['city']				= $returnVal->city;
						$insert['verticalName']		= $returnVal->verticalName;
						$insert['contractName']		= $returnVal->contractName;
						$insert['buyerID']			= $returnVal->buyerID;
						$insert['buyerName']		= $returnVal->buyerName;
						// $insert['addDate']		= '2024-01-30';
						$insert['addDate']			= date("Y-m-d", strtotime("-1 day"));//live

						$this->cron_model->add_report($insert); //only for live
					}
                }
               /*
                echo '<pre>';
                print_r($returnData);
                echo '</pre>';
                */
                
				$this->send_mail($returnData);
            }
        }
    }


	function send_mail($returnData)
	{
		if(count($returnData)>0)
		{
			$emailTemp = $this->cron_model->get_email_template();
			//$variables= $this->cron_model->get_email_variables();
			$email_subject = str_replace("{{DATE}}", date("Y-m-d", strtotime("-1 day")), $emailTemp['subject']);
			$html_email_template = '<!DOCTYPE html>
									<html lang="en">
									<head>
									<meta charset="UTF-8">
									<title>Email Template with Table</title>
									<style>
										/* Define styles for your table */
										table {
										border-collapse: collapse;
										width: 100%;
										}
										th, td {
										border: 1px solid #dddddd;
										text-align: left;
										padding: 8px;
										}
										th {
										background-color: #f2f2f2;
										}
									</style>
									</head>
									<body>';
			$html_email_template .= $emailTemp['body'];
			$html_email_template .= '</body></html>';
			
			$todaysBuyer = array();
			
			foreach ($returnData as $buyerArr) 
			{

				if(count($buyerArr)>0)
				{
				    $config = array(
                        'protocol' => 'smtp', // 'mail', 'sendmail', or 'smtp'
                        'smtp_host' => 'smtp.gmail.com',
                        'smtp_port' => 587,
                        'smtp_user' => 'developer.pappu@gmail.com',
                        'smtp_pass' => 'letp ozuq mpwn cgkq',
                        'smtp_crypto' => 'security', //can be 'ssl' or 'tls' for example
                        'mailtype' => 'html', //plaintext 'text' mails or 'html'
                        'smtp_timeout' => '4', //in seconds
                        'charset' => 'utf-8',
                        'wordwrap' => TRUE
                    );
                    
                   
                    
				    $file_path ='';
					$idArray = array_column($buyerArr, 'contractID');
					array_multisort($idArray, SORT_ASC, $buyerArr);
					 
                    array_push($todaysBuyer,$buyerArr[0]['buyerID']);

					$buyer['buyerID'] 			=  $buyerArr[0]['buyerID'];
					$buyer['buyerName'] 		=  $buyerArr[0]['buyerName'];
					$buyer['buyerEmail'] 		=  'adops@callsbybrand.com';
					$buyer['addDate']			= date('Y-m-d');

                    $to = $this->cron_model->buyer_email($buyer); //live
                    $from = 'reports@callsbybrand.com';
                    //$to= 'palash@colbygroup.net,adops@callsbybrand.com,maddy@callsbybrand.com'; //test
                    $subject = 'CBB Month to Date Call Logs - '.date('Y-m-d');

					$table_html = '<table>
									<thead>
									<tr>
									<th>Name of campaign</th>
									<th>Daily Calls</th>
									<th>Daily AVG Duration (sec)</th>
									<th>Daily Revenue</th>
									</tr>
									</thead>
									<tbody>';

                    $tempPrArr = array();
                    $tempPrId = 0;
                    $tempContartCount = 0;
					foreach ($buyerArr as $data) {
					    
					    if($tempPrId !== $data['contractID'])
					    {
                            $tempPrArr[$data['contractID']] = $data;
                            $tempPrArr[$data['contractID']]['contract_counter'] = 1;
                            $tempPrArr[$data['contractID']]['total_revenue'] = $data['revenue'];
                            $tempPrArr[$data['contractID']]['total_transferDuration'] = $data['transferDuration'];
					    }
					    
					    if($tempPrId === $data['contractID'])
					    {
					        $tempPrArr[$data['contractID']]['contract_counter'] = $tempPrArr[$data['contractID']]['contract_counter']+1;
					        $tempPrArr[$data['contractID']]['total_revenue'] = (float)$tempPrArr[$data['contractID']]['total_revenue']+$data['revenue'];
					        $tempPrArr[$data['contractID']]['total_transferDuration'] = $tempPrArr[$data['contractID']]['total_transferDuration']+$data['transferDuration'];
					    }
					    
					    $tempPrId = $data['contractID'];
					    $tempContartCount++;
					    
                        if(count($buyerArr) == $tempContartCount)
                        {
                            foreach ($tempPrArr as $finalArr) 
                            {
                                $table_html .= '<tr>
                        			<td>' . htmlspecialchars($finalArr['contractName']) . '</td>
                        			<td>' . htmlspecialchars($finalArr['contract_counter']) . '</td>
                        			<td>' . htmlspecialchars(round($finalArr['total_transferDuration']/$finalArr['contract_counter'], 2)) . '</td>
                        			<td>$' . htmlspecialchars($finalArr['total_revenue']) . '</td></tr>';
                            
                            }
                        }		    
					}
					
					$table_html .= '</tbody>
									</table>';

					$placeholders = array('{{BUYERNAME}}', '{{TABLE}}','{{DATE}}');
					$actual_values = array($buyerArr[0]['buyerName'], $table_html, date("Y-m-d", strtotime("-1 day")));

					$final_email_content = str_replace($placeholders, $actual_values, $html_email_template);

				//	echo $final_email_content;

					$file_path = './csv/'.$buyerArr[0]['buyerID'].'-'.date('Y-m-d').'.xlsx';
					$this->generate_excel($buyerArr[0]['buyerID'],$file_path);

                    $this->email->clear(TRUE);
                    $this->load->library('email',$config); 
                    $this->email->set_mailtype("html");
                    $this->email->set_newline("\r\n");
                    $this->email->set_crlf("\r\n");

                    $this->email->from( $from, 'Callsbybrand');
                    $this->email->to($to);
                    $this->email->bcc('reports@callsbybrand.com');
                    $this->email->subject($subject);
                    $this->email->message($final_email_content);
				    $this->email->attach($file_path); 
  
					if ($this->email->send()) {
						echo 'Email sent successfully!';
					} else {
						echo 'Email sending failed.';
						echo $this->email->print_debugger(); // Print email debug information if needed
					}
					
					if(count($todaysBuyer) === count($returnData))
					{
					    $this->sendmail_rest_buyer($todaysBuyer);
					}
					
				}
			}
		}
	}
	
	function sendmail_rest_buyer($buyerArr)
	{
	    $notListedBuyer = $this->cron_model->get_rest_buyer($buyerArr);

	    if(count($notListedBuyer)>0)
		{
			$emailTemp = $this->cron_model->get_email_template_for_notListedBuyer();
			$email_subject = str_replace("{{DATE}}", date("Y-m-d", strtotime("-1 day")), $emailTemp['subject']);
			$html_email_template = '<!DOCTYPE html>
									<html lang="en">
									<head>
									<meta charset="UTF-8">
									<title>Email Template with Table</title>
									<style>
										/* Define styles for your table */
										table {
										border-collapse: collapse;
										width: 100%;
										}
										th, td {
										border: 1px solid #dddddd;
										text-align: left;
										padding: 8px;
										}
										th {
										background-color: #f2f2f2;
										}
									</style>
									</head>
									<body>';
			$html_email_template .= $emailTemp['body'];
			$html_email_template .= '</body></html>';
			

			foreach ($notListedBuyer as $buyerArr) 
			{

				if(count($buyerArr)>0)
				{
				    $returnData = $this->cron_model->get_all_report($buyerArr['buyerID']);
				    
				    if(count($returnData)>0)
				    {
    				    $config = array(
                            'protocol' => 'smtp', // 'mail', 'sendmail', or 'smtp'
                            'smtp_host' => 'smtp.gmail.com',
                            'smtp_port' => 587,
                            'smtp_user' => 'developer.pappu@gmail.com',
                            'smtp_pass' => 'letp ozuq mpwn cgkq',
                            'smtp_crypto' => 'security', //can be 'ssl' or 'tls' for example
                            'mailtype' => 'html', //plaintext 'text' mails or 'html'
                            'smtp_timeout' => '4', //in seconds
                            'charset' => 'utf-8',
                            'wordwrap' => TRUE
                        );
                        
                       
                        
    				    $file_path ='';
    
                        $to = $buyerArr['buyerEmail']; //live
                        $from = 'reports@callsbybrand.com';
                        //$to= 'palash@colbygroup.net,adops@callsbybrand.com,maddy@callsbybrand.com'; //test
                        $subject = 'CBB Month to Date Call Logs - '.date('Y-m-d');
    
    					$placeholders = array('{{BUYERNAME}}','{{DATE}}');
    					$actual_values = array($buyerArr['buyerName'], date("Y-m-d", strtotime("-1 day")));
    
    					$final_email_content = str_replace($placeholders, $actual_values, $html_email_template);
    
    					//echo $final_email_content;
    
    					$file_path = './csv/'.$buyerArr['buyerID'].'-'.date('Y-m-d').'.xlsx';
    					$this->generate_excel($buyerArr['buyerID'],$file_path);
    
                        $this->email->clear(TRUE);
                        $this->load->library('email',$config); 
                        $this->email->set_mailtype("html");
                        $this->email->set_newline("\r\n");
                        $this->email->set_crlf("\r\n");
    
                        $this->email->from( $from, 'Callsbybrand');
                        $this->email->to($to);
                        $this->email->bcc('reports@callsbybrand.com');
                        $this->email->subject($subject);
                        $this->email->message($final_email_content);
    				    $this->email->attach($file_path); 
      
    					if ($this->email->send()) {
    						echo 'Email sent successfully@@!';
    					} else {
    						echo 'Email sending failed.';
    						echo $this->email->print_debugger(); // Print email debug information if needed
    					}
				    }
				}
			}
		}
	}

	function generate_excel($buyer_id,$file_path)
	{
		$this->load->library('SimpleXLSXGen');

		$returnData = $this->cron_model->get_all_report($buyer_id);

		$xlsx = new SimpleXLSXGen();

		$csv_header = ['contractID','callFrom','transferDuration','revenue','createdOn','country','region','city','verticalName','contractName','buyerID','buyerName','date'];
		$count=0;
		$contractchecking =0;
		$appendCounter=	1;
		$duration = 0;
		$revenue = 0;
		$csvData = array();
		$nameArray = array_column($returnData, 'contractID');
		$distinctLengths = array_unique(array_map('strlen', $nameArray));
		foreach ($returnData as $data) 
		{
			if($count === 0){
				array_push($csvData,$csv_header);
				array_push($csvData,$data);

			}elseif($contractchecking === $data['contractID']){
				array_push($csvData,$data);
				$appendCounter++;
			}elseif($contractchecking != $data['contractID']){
				$appendCounter = 0;
			}
			$count++;
			if(count($distinctLengths) ===1 && count($returnData) === $count)
			{
				$appendCounter = 0;
			}

			if($appendCounter===0){
				$row_count = count($csvData)-1;
				$xlsx->addSheet($csvData,$csvData[1]['contractID'].' ('.$row_count.')');
				$duration = 0;
				$revenue = 0;
				$csvData = array();
				array_push($csvData,$csv_header);
				array_push($csvData,$data);
			}
			$contractchecking = $data['contractID'];
		}
		$xlsx->saveAs($file_path);
	}
}
